/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.helper;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.User;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Date;
import jtbcore.app.DbAppConfig;
import jtbcore.db.model.DatabaseModel;
import jtbcore.event.LookupChain;
import jtbcore.event.MessageBus;
import jtbcore.model.BaseStringMap;
import jtbcore.setting.IniParser;
import jtbcore.util.NumberUtil;
import jtbcore.util.PasswordUtil;
import jtbcore.util.StringUtil;

public class ErpConfig
extends DbAppConfig {
    protected String servletRoot = null;
    protected IniParser iniParser;
    protected static Boolean isWinService = null;

    public ErpConfig() {
        try {
            this.iniParser = new IniParser(ErpObjectContainer.getInstance().getDataDir() + "/settings.ini");
            this.iniParser.load();
            if (this.iniParser.get("main", "serverPort") == null) {
                this.iniParser.set("main", "serverPort", 49365);
            }
            if (this.iniParser.get("main", "localOnly") == null) {
                this.iniParser.set("main", "localOnly", ErpConfig.runsAsWinService() ? 0 : 1);
            }
            if (this.iniParser.get("main", "desktopMode") == null) {
                this.iniParser.set("main", "desktopMode", 1);
            }
            if (this.iniParser.get("main", "startBrowser") == null) {
                this.iniParser.set("main", "startBrowser", 1);
            }
            this.iniParser.saveIfNew();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getAppName() {
        String n = ErpObjectContainer.getInstance().getProperty("publicAppName");
        if (n != null) {
            return n;
        }
        return "Contractbeheer";
    }

    public static boolean runsAsWinService() {
        if (isWinService == null) {
            String osname;
            isWinService = false;
            if ("1".equals(System.getProperty("runwinservice")) && (osname = System.getProperty("os.name")) != null && osname.toLowerCase().indexOf("win") != -1) {
                isWinService = true;
            }
        }
        return isWinService;
    }

    public IniParser getIniParser() {
        return this.iniParser;
    }

    public Integer getLimit() {
        return 15;
    }

    public Integer getSettingInt(String settingCode) throws SQLException {
        String s = this.getSetting(settingCode);
        return NumberUtil.tryParseInt(s);
    }

    public Integer getSettingInt(String settingCode, Integer defaultValue) throws SQLException {
        Integer i = this.getSettingInt(settingCode);
        if (i != null) {
            return i;
        }
        return defaultValue;
    }

    public String getSetting(String settingCode, String defaultValue) throws SQLException {
        String v = this.getSetting(settingCode);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public String getSetting(String settingCode) throws SQLException {
        String s = (String)this.connection.queryValue("select text_value from base__setting where setting_code = ?", String.class, settingCode);
        return s;
    }

    public void setSetting(String settingCode, Integer val) throws SQLException, IOException {
        this.setSetting(settingCode, val != null ? val.toString() : null);
    }

    public void setSetting(String settingCode, String val) throws SQLException, IOException {
        Integer settingId = (Integer)this.connection.queryValue("select setting_id from base__setting where setting_code = ?", Integer.class, settingCode);
        BaseStringMap bsm = new BaseStringMap();
        if (settingId != null) {
            bsm.setProperty("setting_id", settingId);
        }
        bsm.setProperty("setting_code", settingCode);
        bsm.setProperty("text_value", val);
        this.connection.save("base__setting", "setting_id", bsm);
    }

    public String getServletRoot() {
        return this.servletRoot;
    }

    public void setServletRoot(String servletRoot) {
        this.servletRoot = servletRoot;
    }

    public String getResourceAsString(String p) throws IOException {
        InputStream is = this.getInputStream(p);
        if (is == null) {
            return null;
        }
        String r = StringUtil.inputStream2String(is);
        is.close();
        return r;
    }

    public InputStream getInputStream(String p) throws FileNotFoundException {
        InputStream is;
        File f;
        if (this.servletRoot != null && p.startsWith("src/itx/erp/resources")) {
            System.out.println("test1: " + this.servletRoot);
            System.out.println("test2: " + p);
            String p2 = p.replace("src/itx/erp/resources/", "/WEB-INF/classes/");
            File f2 = new File(this.servletRoot + p2);
            System.out.println("test3: " + f2.getAbsolutePath());
            if (f2.exists() && f2.getAbsolutePath().startsWith(this.servletRoot)) {
                return new FileInputStream(f2);
            }
        }
        if ((f = new File(p)).exists() && f.isFile()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if ((is = ErpConfig.class.getResourceAsStream(p)) == null) {
            is = p.startsWith("/") ? ErpConfig.class.getResourceAsStream("/src" + p) : ErpConfig.class.getResourceAsStream("/src/" + p);
        }
        if (is == null && p.startsWith("src/main")) {
            is = ErpConfig.class.getResourceAsStream(p.substring(18));
        }
        if (is == null && p.startsWith("src/main")) {
            is = ErpConfig.class.getResourceAsStream("../../../" + p.substring(8));
        }
        if (is == null && p.startsWith("/static/")) {
            is = ErpConfig.class.getResourceAsStream("/itx/erp/resources" + p);
        }
        if (is == null) {
            is = (InputStream)LookupChain.getInstance().lookup("ErpConfig.getInputStream", p);
        }
        return is;
    }

    public static Boolean resourceExists(String p) {
        URL u = ErpConfig.class.getResource(p);
        File f = new File(p);
        if (f.exists()) {
            return true;
        }
        if (u == null) {
            if (!p.startsWith("/src")) {
                if (p.startsWith("/")) {
                    return ErpConfig.resourceExists("/src" + p);
                }
                return ErpConfig.resourceExists("/src/" + p);
            }
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        this.initTables();
        DatabaseModel dmBase = ErpObjectContainer.getInstance().getDmBase();
        this.connection.initModel(dmBase);
        Integer cnt = (Integer)this.connection.queryValue("select count(*) from base__user", Integer.class, new Object[0]);
        if (cnt == 0) {
            BaseStringMap bsm = new BaseStringMap();
            bsm.setProperty("username", "admin");
            if (ErpConfig.runsAsWinService()) {
                bsm.setProperty("password", "admin123");
            } else {
                bsm.setProperty("password", User.hashPassword(PasswordUtil.generatePassword()));
            }
            bsm.setProperty("user_type", "admin");
            bsm.setProperty("activated", true);
            bsm.setProperty("edited", new Date());
            bsm.setProperty("created", new Date());
            this.connection.insertRecord("base__user", bsm);
        }
        DatabaseModel dmCustomer = ErpObjectContainer.getInstance().getDmCustomer();
        this.connection.initModel(dmCustomer);
        DatabaseModel dbWebmail = ErpObjectContainer.getInstance().getDmEmail();
        this.connection.initModel(dbWebmail);
        MessageBus.getInstance().sendMessage("ErpConfig.initTables", this);
    }

    public Integer getServerPort() {
        return this.iniParser.getInt("main", "serverPort", 49365);
    }

    public boolean isLocalOnly() {
        return this.iniParser.getBool("main", "localOnly", true);
    }

    public boolean isDesktopMode() {
        if (ErpConfig.runsAsWinService()) {
            return false;
        }
        return "1".equals(System.getProperty("jtoolbox.desktopMode"));
    }

    public boolean skipPasswordCheck() {
        Boolean b = this.iniParser.getBool("main", "skipPasswordCheck", false);
        return b;
    }

    public boolean startBrowser() {
        if (ErpConfig.runsAsWinService()) {
            return false;
        }
        return this.isDesktopMode();
    }

    @Override
    public Integer getAppVersion() {
        String n = ErpObjectContainer.getInstance().getProperty("internalVersion");
        Integer o = NumberUtil.tryParseInt(n);
        if (o != null) {
            return 0;
        }
        return 20250327;
    }

    public String buildAdminUrl(String path) throws SQLException {
        Object adminUrl = (String)LookupChain.getInstance().lookup("adminUrl", null);
        if (StringUtil.isEmpty((String)adminUrl)) {
            adminUrl = this.getSetting("adminUrl");
        }
        if (adminUrl == null || ((String)adminUrl).trim().length() == 0) {
            adminUrl = "http://localhost:" + String.valueOf(this.getServerPort());
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        String url = StringUtil.normalizeUrl((String)adminUrl + (String)path);
        return url;
    }
}

